package ch.frankel.blog.validation;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertSame;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import java.util.Set;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;

import org.junit.Before;
import org.junit.Test;

import ch.frankel.blog.validation.model.group.Person;
import ch.frankel.blog.validation.validator.DummyGroup;

public class GroupValidationTest {

	private Validator validator;

	@Before
	public void setUp() throws Exception {

		validator = Validation.buildDefaultValidatorFactory().getValidator();
	}

	/**
	 * Tests composition validation. Checks there's no violation when
	 * <code>firstName</code> is <code>null</code> and using the default group.
	 */
	@Test
	public void validatePersonNullDefaultGroup() {

		Person person = new Person();

		Set<ConstraintViolation<Person>> violations = validator.validate(
				person, Default.class);

		assertTrue(violations.isEmpty());
	}

	/**
	 * Tests composition validation. Checks there's no violation when
	 * <code>firstName</code> is <code>null</code> and using the default group.
	 */
	@Test
	public void validatePersonNullDummyGroup() {

		Person person = new Person();

		Set<ConstraintViolation<Person>> violations = validator.validate(
				person, DummyGroup.class);

		assertFalse(violations.isEmpty());
		assertEquals(1, violations.size());

		ConstraintViolation<Person> violation = violations.iterator().next();

		assertEquals("firstName", violation.getPropertyPath().iterator().next()
				.getName());
		assertSame(NotNull.class, violation.getConstraintDescriptor()
				.getAnnotation().annotationType());
	}
}
